USE [V5_Registry]
GO
	--Insert Survey Information
	INSERT INTO [dbo].[STD_SURVEY_TYPE]
           ([CODE],[NAME],[DESCRIPTION_TEXT],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES
           ('FMA', 'Functional Mobility Assessment', 'Functional Mobility Assessment', 'Initial', 'Initial', GETDATE(), GETDATE());

	declare @type     int;
	SELECT @type=  (SELECT ID [STD_SURVEY_TYPE_ID]
	FROM STD_SURVEY_TYPE
	WHERE CODE = 'FMA');

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, 'D', 'Date of assessment:', 1, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '1', 'What is your current means of mobility device?', 2, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '2', 'My current means of mobility allows me to carry out my daily routine as independently, safely and effeciently as possible:
					     (e.g., tasks I want to do, need to do, am required to do-when and where needed)', 3, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '2Comment', 'Comments:', 4, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '2R', 'Rating:', 5, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '3', 'My current means of mobility meets my comfort needs:
					     (e.g., heat/moisture, sitting tolerance, pain, stability)', 6, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '3Comment', 'Comments:', 7, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '3R', 'Rating:', 8, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '4', 'My current means of mobility meets my health needs:
					     (e.g., pressure sores, breathing, edema control, medical equipment)', 9, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '4Comment', 'Comments:', 10, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '4R', 'Rating:', 11, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '5', 'My current means of mobility allows me to be as independent, safe and effecient as possible:
					     (e.g., do what I want it to do when and where I want to do it)', 12, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '5Comment', 'Comments:', 13, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '5R', 'Rating:', 14, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '6', 'My current means of mobility allows me to reach and carry out tasks at different surface heights as independently, safely and effeciently as possible:
					     (e.g., table, counters, floors, shelves)', 15, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '6Comment', 'Comments:', 16, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '6R', 'Rating:', 17, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '7', 'My current means of mobility allows me to transfer from one surface to another:
					     (e.g., bed, toilet, chair)', 18, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '7Comment', 'Comments:', 19, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '7R', 'Rating:', 20, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '8', 'My current means of mobility allows me to carry out personal care tasks:
					     (e.g., dressing, bowel/bladder care, eating, hygiene)', 21, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '8Comment', 'Comments:', 22, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '8R', 'Rating:', 23, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '9', 'My current means of mobility allows me to get around indoors:
					     (e.g., home, work, mall, restaurants, ramps, obstacles)', 24, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '9Comment', 'Comments:', 25, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '9R', 'Rating:', 26, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '10', 'My current means of mobility allows me to get around outdoors:
					     (e.g., uneven surfaces, dirt, grass, gravel, ramps, obstacles)', 27, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '10Comment', 'Comments:', 28, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '10R', 'Rating:', 29, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '11', 'My current means of mobility allows me to use personal or public transportation as independently, safely and effeciently as possible:
					     (e.g., secure, stow, ride)', 30, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '11Comment', 'Comments:', 31, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '11R', 'Rating:', 32, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	declare @question     int, 
			@choice       int;     

	--Date Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 1)
	--Date Choice
	SET @choice = ((SELECT MAX(STD_QUESTION_CHOICE_ID) from [dbo].[STD_QUESTION_CHOICE]) + 1)
	--If choice is null, meaning the choice table is empty, set it to 1
	IF @choice IS NULL SET @choice = 1
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Date', 'Date', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 1 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 2)
	--Question 1 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Walking', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Walker', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'Cane', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Crutch', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Manual Wheelchair', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', 'Power Wheelchair', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', 'Scooter', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())


	--Question 2 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 3)
	--Question 2 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Completely Agree', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Mostly Agree', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'Slightly Agree', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Slightly Disagree', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Mostly Disagree', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', 'Completely Disagree', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', 'Does not apply', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 2 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 4)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 2 Comments' ,'Question 2 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 2 Rating Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 5)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 2 Rating' ,'Question 2 Rating',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 3 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 6)
	--Question 3 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Completely Agree', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Mostly Agree', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'Slightly Agree', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Slightly Disagree', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Mostly Disagree', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', 'Completely Disagree', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', 'Does not apply', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 3 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 7)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 3 Comments' ,'Question 3 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 3 Rating Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 8)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 3 Rating' ,'Question 3 Rating',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 4 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 9)
	--Question 4 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Completely Agree', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Mostly Agree', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'Slightly Agree', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Slightly Disagree', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Mostly Disagree', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', 'Completely Disagree', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', 'Does not apply', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 4 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 10)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 4 Comments' ,'Question 4 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 4 Rating Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 11)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 4 Rating' ,'Question 4 Rating',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 5 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 12)
	--Question 5 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Completely Agree', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Mostly Agree', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'Slightly Agree', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Slightly Disagree', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Mostly Disagree', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', 'Completely Disagree', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', 'Does not apply', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 5 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 13)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 5 Comments' ,'Question 5 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 5 Rating Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 14)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 5 Rating' ,'Question 5 Rating',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 6 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 15)
	--Question 6 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Completely Agree', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Mostly Agree', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'Slightly Agree', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Slightly Disagree', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Mostly Disagree', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', 'Completely Disagree', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', 'Does not apply', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 6 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 16)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 6 Comments' ,'Question 6 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 6 Rating Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 17)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 6 Rating' ,'Question 6 Rating',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 7 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 18)
	--Question 7 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Completely Agree', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Mostly Agree', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'Slightly Agree', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Slightly Disagree', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Mostly Disagree', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', 'Completely Disagree', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', 'Does not apply', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 7 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 19)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 7 Comments' ,'Question 7 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 7 Rating Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 20)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 7 Rating' ,'Question 7 Rating',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 8 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 21)
	--Question 8 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Completely Agree', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Mostly Agree', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'Slightly Agree', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Slightly Disagree', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Mostly Disagree', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', 'Completely Disagree', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', 'Does not apply', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 8 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 22)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 8 Comments' ,'Question 8 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 8 Rating Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 23)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 8 Rating' ,'Question 8 Rating',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 9 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 24)
	--Question 9 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Completely Agree', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Mostly Agree', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'Slightly Agree', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Slightly Disagree', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Mostly Disagree', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', 'Completely Disagree', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', 'Does not apply', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 9 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 25)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 9 Comments' ,'Question 9 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 9 Rating Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 26)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 9 Rating' ,'Question 9 Rating',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 10 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 27)
	--Question 10 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Completely Agree', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Mostly Agree', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'Slightly Agree', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Slightly Disagree', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Mostly Disagree', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', 'Completely Disagree', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', 'Does not apply', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 10 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 28)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 10 Comments' ,'Question 10 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 10 Rating Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 29)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 10 Rating' ,'Question 10 Rating',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 11 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 30)
	--Question 11 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'Completely Agree', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'Mostly Agree', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'Slightly Agree', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'Slightly Disagree', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'Mostly Disagree', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', 'Completely Disagree', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', 'Does not apply', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 11 Comment Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 31)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 11 Comments' ,'Question 11 Comments',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 11 Rating Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'FMA' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 32)	
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
			   ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
			   ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
		 VALUES
			   (@choice, @question, 'Question 11 Rating' ,'Question 11 Rating',	1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

GO